<?php
require_once 'load_data.php';
$allData = getAllData();
$jsonData = json_encode($allData, JSON_UNESCAPED_UNICODE);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SAE 303 - Temps de Parole des Femmes dans les Médias</title>
    
    <!-- Librairies -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/mathjs/11.11.0/math.min.js"></script>
    <script src="https://d3js.org/d3.v7.min.js"></script>
    
    <!-- Animation Glitch-->
    <script type="module">
      import GlitchEffect from './glitch-effect.js';
    </script>
    
    <!-- CSS TV Rétro -->
    <link rel="stylesheet" href="tv-retro.css">
     <link rel="stylesheet" href="tv-texture.css">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="artistic-mode.css">
    <link rel="stylesheet" href="tv-intro.css">
     <link rel="stylesheet" href="tv-outro.css">
     <link rel="stylesheet" href="navigation.css">
    <link rel="stylesheet" href="final-enhancements.css">
    
    <!-- Données -->
    <script>
        window.CSV_DATA = <?php echo $jsonData; ?>;
    </script>
</head>
<body>
    <!-- Barre de progression de défilement -->
    <div class="tv-progress-bar" id="tvProgressBar"></div>

    <!-- Container Principal TV Rétro -->
    <div class="tv-retro-container" id="tvRetroContainer">
        
        <!-- Cadre TV -->
        <div class="tv-frame">
            <div class="tv-screen">
                
                <!-- Effets CRT -->
                <div class="tv-scanlines"></div>
                <div class="tv-vignette"></div>
                <div class="tv-flicker"></div>
                <div class="tv-glow"></div>
                <div class="tv-curvature"></div>
                <div class="tv-scanline-bar"></div>
                
                <!-- En-tête TV & Horloge & CRT-->
                <div class="tv-top-status">
                    <div class="crt-status">
                        <span class="led"></span>
                        CRT: ON
                    </div>
                    <div class="marquee-container">
                        <div class="tv-clock-marquee" id="tvClock">00:00:00</div>
                    </div>
                    
                 <!-- Indicateur de Mode -->
                <div class="tv-mode-indicator">
                    <button class="tv-mode-btn" id="downloadPDF" title="Télécharger le graphique en PDF">
                    <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    VOIR L'INFOGRAPHIE PDF
                </button>
                    
                    
                    <button class="tv-mode-btn active" id="modeScientific">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2v20M2 12h20"></path>
                            <circle cx="12" cy="12" r="9"></circle>
                        </svg>
                        Scientifique
                    </button>
                
                    
                    <a href="artistic.php" class="tv-mode-btn" id="modeArtisticLink">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                        </svg>
                        Artistique
                    </a>
                </div>
                
            </div>
                
                <!-- Signal -->
                <div class="tv-signal">
                    <div class="tv-signal-bars">
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                    </div>
                    <span>SIGNAL</span>
                </div>
                
                <!-- Header Principal -->
                <header class="tv-header">
                    <div class="tv-title">
                        <h1>Répartition du temps de parole des femmes par années et par chaînes
                            <span class="year-display" id="yearDisplay">
                                <span class="year" id="currentYear">2019</span>
                                <svg class="year-arrow" viewBox="0 0 24 24" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="6 9 12 15 18 9"></polyline>
                                </svg>
                            </span>
                        </h1>
                    </div>
                    
                <!-- FILTRE TOUS / TV / RADIO -->
                    <div class="media-filter-container">
                        <div class="media-filter-title">Filtrer par média :</div>
                        <div class="media-filter-options">
                            <label class="filter-checkbox">
                                <input type="checkbox" id="filter-all" checked>
                                <span class="checkmark"></span>
                                TOUS
                            </label>
                            <label class="filter-checkbox">
                                <input type="checkbox" id="filter-tv">
                                <span class="checkmark"></span>
                                TV
                                <span class="channel-count">(34 chaînes)</span>
                            </label>
                            <label class="filter-checkbox">
                                <input type="checkbox" id="filter-radio">
                                <span class="checkmark"></span>
                                Radio
                                <span class="channel-count">(21 chaînes)</span>
                            </label>
                        </div>
                    </div>
                    
                <div id="channel-selector-container" class="channel-dropdown-container" style="position: relative;">
                <div class="channel-dropdown-header">
                    <span id="channel-dropdown-label">Sélectionner les chaînes</span>
                    <svg viewBox="0 0 24 24" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="6 9 12 15 18 9"></polyline>
                    </svg>
                </div>
                <div id="channel-options-list" class="channel-options-grid">
                    </div>
            </div>

                    
                    <!-- Dropdown Sélecteur d'Année -->
                    <div class="year-dropdown-container">
                        <div class="year-dropdown" id="yearDropdown">
                            <div class="year-dropdown-header">
                                <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                    <line x1="16" y1="2" x2="16" y2="6"></line>
                                    <line x1="8" y1="2" x2="8" y2="6"></line>
                                    <line x1="3" y1="10" x2="21" y2="10"></line>
                                </svg>
                                <span>Sélectionner une année</span>
                            </div>
                            <div class="year-dropdown-options" id="yearDropdownOptions">
                                <!-- Les options seront générées par JavaScript -->
                            </div>
                        </div>
                    </div>
            </header>
                
                <!-- Zone Graphique -->
                <div class="tv-chart-area" style="margin-top: 80px;">
                    <!-- Navigation Gauche -->
                    <button class="tv-nav-btn" id="chartLeft" title="Graphique précédent">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="15 18 9 12 15 6"></polyline>
                        </svg>
                    </button>
                    
                    <!-- Container Graphique -->
                    <div class="tv-chart-container">
                        <canvas id="mainChart"></canvas>
                        <div id="d3Chart" style="width:900px; height:500px; display:none;"></div>
                    </div>
                    
                    <!-- Navigation Droite -->
                    <button class="tv-nav-btn" id="chartRight" title="Graphique suivant">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </button>
                </div>
                
                <!-- Légende -->
                <div class="tv-legend" id="customLegend">
                <div class="tv-legend-item" onclick="toggleDataset(0)" data-index="0">
                    <span class="tv-legend-dot male"></span>
                    <span class="tv-legend-label">Hommes</span>
                </div>
                <div class="tv-legend-item" onclick="toggleDataset(1)" data-index="1">
                    <span class="tv-legend-dot female"></span>
                    <span class="tv-legend-label">Femmes</span>
                </div>
            </div>
                
                <!-- Barre de Métriques -->
                <div class="tv-metrics">
                    <div class="tv-metric">
                        <div class="tv-metric-trend down">- 23%</div>
                        <div class="tv-metric-value" id="variance">4,635</div>
                        <div class="tv-metric-label">Variance</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend down">- 9%</div>
                        <div class="tv-metric-value" id="stdDev">3.17</div>
                        <div class="tv-metric-label">Écart-type</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend up">+ 80%</div>
                        <div class="tv-metric-value" id="correlation">0.72</div>
                        <div class="tv-metric-label">Corrélation</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend up">+ 7%</div>
                        <div class="tv-metric-value" id="median">45.3%</div>
                        <div class="tv-metric-label">Médiane</div>
                    </div>
                </div>
                
            </div>
        </div>
        
        <!-- Compteur de Données -->
        <div class="tv-data-counter" id="tvDataCounter">
            DONNÉES <span>000</span>
        </div>
        
        
        <!-- Graphisme de défilement TV -->
        <div class="tv-scroll-graphic">
            <svg class="tv-scroll-icon up" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="18 15 12 9 6 15"></polyline>
            </svg>
            <div class="tv-scroll-track">
                <div class="tv-scroll-position"></div>
            </div>
            <svg class="tv-scroll-icon down" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="6 9 12 15 18 9"></polyline>
            </svg>
            <div class="tv-scroll-counter">SCROLL</div>
        </div>
    </div>

        <!-- Pop UP information indicateur mathématique -->
        <div id="stats-tooltip" class="stats-popup">
            <div class="popup-content">
                <h4 id="popup-title">Analyse</h4>
                <p id="popup-calc" class="calc-formula"></p>
                <p id="popup-analysis" class="analysis-text"></p>
            </div>
        </div>

    <!-- Sélecteur d'année (caché) -->
    <select id="yearFilter" style="display:none;">
        <?php
        $yearsData = getYearsData();
        foreach ($yearsData['years'] as $year) {
            $selected = ($year == '2019') ? 'selected' : '';
            echo "<option value='$year' $selected>$year</option>";
        }
        ?>
    </select>

    <!-- Scripts -->
    <script src="tv-graphics.js"></script>
    <script src="main-chart.js"></script>
    <script src="tv-intro.js"></script>
    <script src="tv-outro.js"></script>
    
    <script>
        // Mise à jour de l'année
        document.getElementById('yearDisplay').addEventListener('click', function(e) {
            e.stopPropagation();
            const dropdown = document.getElementById('yearDropdown');
            const yearRect = this.getBoundingClientRect();
            
            // Positionner le dropdown directement sous l'élément cliqué avec position fixed
            dropdown.style.top = (yearRect.bottom + 8) + 'px';
            dropdown.style.left = yearRect.left + 'px';
            dropdown.style.right = 'auto';
            
            dropdown.classList.toggle('open');
        });
        
        // Empêcher la propagation des clics dans le dropdown
        document.getElementById('yearDropdown').addEventListener('click', function(e) {
            e.stopPropagation();
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            const dropdown = document.getElementById('yearDropdown');
            const display = document.getElementById('yearDisplay');
            if (!dropdown.contains(e.target) && !display.contains(e.target)) {
                dropdown.classList.remove('open');
            }
        });
        
        // Générer les options du dropdown
        function generateYearDropdown() {
            const yearFilter = document.getElementById('yearFilter');
            const optionsContainer = document.getElementById('yearDropdownOptions');
            
            if (yearFilter && optionsContainer) {
                const options = yearFilter.options;
                const currentYear = yearFilter.value;
                
                for (let i = 0; i < options.length; i++) {
                    const option = document.createElement('div');
                    option.className = 'year-option' + (options[i].value === currentYear ? ' active' : '');
                    option.textContent = options[i].value;
                    option.dataset.year = options[i].value;
                    
                    option.addEventListener('click', function() {
                        selectYear(options[i].value);
                        
                        // Fermer le dropdown
                        document.getElementById('yearDropdown').classList.remove('open');
                    });
                    
                    optionsContainer.appendChild(option);
                }
            }
        }
        
        // Fonction pour sélectionner une année
        function selectYear(year) {
            const yearFilter = document.getElementById('yearFilter');
            if (yearFilter) {
                yearFilter.value = year;
                
                // Mettre à jour l'affichage de l'année avec animation
                const currentYearEl = document.getElementById('currentYear');
                currentYearEl.style.opacity = '0';
                currentYearEl.style.transform = 'translateY(-10px)';
                
                setTimeout(() => {
                    currentYearEl.textContent = year;
                    currentYearEl.style.opacity = '1';
                    currentYearEl.style.transform = 'translateY(0)';
                }, 150);
                
                // Mettre à jour les options actives
                const options = document.querySelectorAll('.year-option');
                options.forEach(opt => {
                    opt.classList.toggle('active', opt.dataset.year === year);
                });
                
                // Mettre à jour le graphique
                if (typeof initMainChart === 'function') {
                    initMainChart();
                }
                
                // Mettre à jour les stats
                if (typeof updateMathematicalStats === 'function') {
                    updateMathematicalStats(year);
                }
            }
        }
        
        // Initialiser le dropdown après le chargement
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(generateYearDropdown, 500);
        });
        
        // SCROLL GRAPHIC FONCTIONNEL
        function initScrollGraphic() {
            const scrollGraphic = document.querySelector('.tv-scroll-graphic');
            const scrollPosition = document.querySelector('.tv-scroll-position');
            const scrollCounter = document.querySelector('.tv-scroll-counter');
            const scrollUp = document.querySelector('.tv-scroll-icon.up');
            const scrollDown = document.querySelector('.tv-scroll-icon.down');
            
            if (!scrollGraphic || !scrollPosition) return;
            
            // Obtenir la hauteur de la page
            const docHeight = document.documentElement.scrollHeight - window.innerHeight;
            let scrollPercent = 0;
            
            // Fonction de mise à jour de la position du scroll
            function updateScrollPosition() {
                scrollPercent = (window.scrollY / docHeight) * 100;
                scrollPercent = Math.max(0, Math.min(100, scrollPercent));
                
                if (scrollPosition) {
                    scrollPosition.style.height = scrollPercent + '%';
                    scrollPosition.style.top = '0';
                }
                
                if (scrollCounter) {
                    const scrollValue = Math.round(scrollPercent);
                    scrollCounter.textContent = scrollValue.toString().padStart(3, '0');
                }
            }
            
            // Gestion du scroll de la page
            window.addEventListener('scroll', function() {
                updateScrollPosition();
            });
            
            // Clic sur le track pour aller à cette position
            scrollGraphic.addEventListener('click', function(e) {
                const rect = scrollGraphic.getBoundingClientRect();
                const clickY = e.clientY - rect.top;
                const clickPercent = clickY / rect.height;
                const targetScroll = clickPercent * docHeight;
                
                window.scrollTo({
                    top: targetScroll,
                    behavior: 'smooth'
                });
            });
            
            // Navigation avec les icônes
            if (scrollUp) {
                scrollUp.addEventListener('click', function(e) {
                    e.stopPropagation();
                    window.scrollBy({
                        top: -window.innerHeight * 0.8,
                        behavior: 'smooth'
                    });
                });
            }
            
            if (scrollDown) {
                scrollDown.addEventListener('click', function(e) {
                    e.stopPropagation();
                    window.scrollBy({
                        top: window.innerHeight * 0.8,
                        behavior: 'smooth'
                    });
                });
            }
            
            // Initialiser la position
            updateScrollPosition();
        }
        
        // Initialiser le scroll graphic
        document.addEventListener('DOMContentLoaded', function() {
            initScrollGraphic();
        });
        
        // bouton pour telecharger pdf graphique 
        document.getElementById('downloadPDF').addEventListener('click', function (e) {
        e.preventDefault();
        
        // Chemin vers votre fichier dans le dossier images
        const filePath = 'images/MEHDI_Maïssa_CHADLI_Selma_Datavisualisation.pdf';
        
        // Création d'un lien temporaire pour forcer le téléchargement
        const link = document.createElement('a');
        link.href = filePath;
        link.download = 'MEHDI_Maïssa_CHADLI_Selma_Datavisualisation.pdf'; // Nom du fichier lors du téléchargement
        
        // Ajout au document et simulation du clic
        document.body.appendChild(link);
        link.click();
        
        // Nettoyage
        document.body.removeChild(link);
    
        // Optionnel : Effet visuel rétro lors du clic
        if (typeof triggerGlitchEffect === 'function') {
            triggerGlitchEffect(150);
        }
    });
    
    

    </script>


</body>
</html>

